"""Configuration objects for Flask app."""
from __future__ import annotations

import os
from pathlib import Path


class Config:
    """Base configuration."""

    SECRET_KEY = os.environ.get("SECRET_KEY", "dev-secret-key-change-me")
    PORT = int(os.environ.get("PORT", 5001))
    _instance_path = Path(
        os.environ.get("FLASK_INSTANCE_PATH", Path.cwd() / "instance")
    ).resolve()
    SQLALCHEMY_DATABASE_URI = os.environ.get(
        "DATABASE_URL",
        f"sqlite:///{(_instance_path / 'app.db').as_posix()}",
    )
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    REMEMBER_COOKIE_DURATION = int(os.environ.get("REMEMBER_COOKIE_DURATION", 60 * 60 * 24 * 7))
    WTF_CSRF_TIME_LIMIT = None


class TestingConfig(Config):
    """Configuration for tests."""

    TESTING = True
    SQLALCHEMY_DATABASE_URI = "sqlite:///:memory:"
    WTF_CSRF_ENABLED = False
